/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.IMTPException;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.mobility.AgentMobilitySlice;
import jade.util.Logger;

class MobileAgentClassLoader
extends ClassLoader {
    private AgentMobilitySlice classServer;
    private String agentName;
    private String sliceName;
    private ServiceFinder finder;
    private Logger myLogger;

    public MobileAgentClassLoader(String an, String sn, ServiceFinder sf) {
        try {
            this.agentName = an;
            this.sliceName = sn;
            this.finder = sf;
            this.classServer = (AgentMobilitySlice)this.finder.findSlice("jade.core.mobility.AgentMobility", this.sliceName);
            this.myLogger = Logger.getMyLogger("jade.core.mobility.AgentMobility");
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classFile;
        try {
            if (this.myLogger != null && this.myLogger.isLoggable(5)) {
                this.myLogger.log(5, "Remote retrieval of code for class " + name);
            }
            try {
                classFile = this.classServer.fetchClassFile(name, this.agentName);
            }
            catch (IMTPException imtpe) {
                this.classServer = (AgentMobilitySlice)this.finder.findSlice("jade.core.mobility.AgentMobility", this.sliceName);
                classFile = this.classServer.fetchClassFile(name, this.agentName);
            }
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            throw new ClassNotFoundException(name);
        }
        catch (ServiceException se) {
            throw new ClassNotFoundException(name);
        }
        if (classFile != null) {
            if (this.myLogger != null && this.myLogger.isLoggable(5)) {
                this.myLogger.log(5, "Code of class " + name + " retrieved. Length is " + classFile.length);
            }
            return this.defineClass(name, classFile, 0, classFile.length);
        }
        throw new ClassNotFoundException(name);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = null;
        if (this.myLogger != null && this.myLogger.isLoggable(4)) {
            this.myLogger.log(4, "Loading class " + name);
        }
        if ((c = this.findLoadedClass(name)) == null) {
            try {
                c = this.findSystemClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (this.myLogger != null && this.myLogger.isLoggable(4)) {
            this.myLogger.log(4, "Class " + name + " loaded");
        }
        return c;
    }
}

